#region Includes
using GroundhogLearning.GameKit.Utils;
using UnityEngine;
using UnityEngine.Events;
#endregion

namespace GroundhogLearning.GameKit.Interactions
{
    [AddComponentMenu(EditorMenuConfig.CATEGORY_INTERACTIONS + "Toggle Interactable")]
    public class ToggleInteractable : Interactable
    {
        #region Variables

        [Header("Events")]
        public UnityEvent<bool> OnActiveStateChanged;

        public bool IsActive { get; private set; }

        #endregion

        public override Interactable Activate(RayInteractor interactor)
        {
            base.Activate(interactor);

            IsActive = !IsActive;
            OnActiveStateChanged?.Invoke(IsActive);

            return null;
        }
    }
}